unit uDataMod;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, DBTables, BDE;

type
  TImpahlaDM = class(TDataModule)
    dbMain: TDatabase;
  private
    { Private declarations }
  public
    { Public declarations }
		procedure GetTableNamesNew(Database:TDatabase; Pattern: string;
								Extensions, SystemTables: Boolean; List: TStrings);
  end;

var
  ImpahlaDM: TImpahlaDM;

implementation

{$R *.DFM}

{----------------------------------------------------------}
procedure TImpahlaDM.GetTableNamesNew(Database:TDatabase; Pattern: string;
	Extensions, SystemTables: Boolean; List: TStrings);
var
	Cursor: HDBICur;
	WildCard: PChar;
	Name: string;
	SPattern: array[0..127] of Char;
	Desc: TBLBaseDesc;
begin
	List.BeginUpdate;
	try
		List.Clear;
		try
			WildCard := nil;
			if Pattern <> '' then
				WildCard := AnsiToNative(Database.Locale, Pattern, SPattern,
					SizeOf(SPattern) - 1);
			Check(DbiOpenTableList(Database.Handle, False, SystemTables,
				WildCard, Cursor));
			try
				while DbiGetNextRecord(Cursor, dbiNOLOCK, @Desc, nil) = 0 do
					with Desc do
					begin
						if Extensions and (szExt[0] <> #0) then
							StrCat(StrCat(szName, '.'), szExt);
						NativeToAnsi(Database.Locale, szName, Name);
						List.Add(Name);
					end;
			finally
				DbiCloseCursor(Cursor);
			end;
		finally
		end;
	finally
		List.EndUpdate;
	end;
end;

end.
