unit uDMCreateAsset;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBTables, Db;

type
  TDMCreateAsset = class(TDataModule)
    dsOtherData: TDataSource;
    sqlOtherFields: TQuery;
    dsOtherFields: TDataSource;
    tblDataQuality: TTable;
    dsDataQuality: TDataSource;
    tblAssetFields: TTable;
    dsAssetFields: TDataSource;
    tblAssetsMain: TTable;
    dsAssetsMain: TDataSource;
    tblAssetsOther: TTable;
    dsAssetsOther: TDataSource;
    tblEquip1: TTable;
    dsEquip1: TDataSource;
    tblEquip2: TTable;
    dsEquip2: TDataSource;
    tblRegions: TTable;
    dsRegions: TDataSource;
    tblSites: TTable;
    dsSites: TDataSource;
    tblSystem1: TTable;
    dsSystem1: TDataSource;
    tblSystem2: TTable;
    dsSystem2: TDataSource;
    tblSystem3: TTable;
    dsSystem3: TDataSource;
    sqlMaxAssetNum: TQuery;
    dsMaxAssetNum: TDataSource;
    sqlOtherData: TQuery;
    procedure dsAssetsMainDataChange(Sender: TObject; Field: TField);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	DMCreateAsset: TDMCreateAsset;

implementation

{$R *.DFM}

uses uCreateAsset, uDataMod;

{----------------------------------------------------------}
procedure TDMCreateAsset.dsAssetsMainDataChange(Sender: TObject;
	Field: TField);
var
	Str: string;
begin
//	MessageDlg('Data Changing', mtInformation, [mbOK], 0);
//	if tblSites.State <> dsInactive then
//		tblSites.Refresh;
	with tblAssetsMain do
	begin
		str :=	FieldByName('RegionCode').AsString +
						FieldByName('SiteCode').AsString + ' - ' +
						FieldByName('Sys1').AsString +
						FieldByName('Sys2').AsString +
						FieldByName('Sys3').AsString + '  ' +
						FieldByName('Equip1').AsString +
						FieldByName('Equip2').AsString +
						Format('%.3d',[FieldByName('Num').AsInteger]){ + ' ' +
            Format('%.3d',[FieldByName('GAID').AsInteger])};
	end;
	with frmCreateAsset do
	begin
		edAssetID.Text := Uppercase(Str);
	end;
end;

{----------------------------------------------------------}
end.
{----------------------------------------------------------}
