unit uCreateAsset;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	Dialogs, Db, DBTables, StdCtrls, Buttons, Grids, DBGrids, Mask,
	DBCtrls, ExtCtrls, ComCtrls, uDMCreateAsset, RXLookup, ToolEdit, RXDBCtrl,
  RxGrdCpt;

type
	TfrmCreateAsset = class(TForm)
		bitbtnCancel: TBitBtn;
		pctrlCreateAsset: TPageControl;
		tshtLocation: TTabSheet;
		lblLocation: TLabel;
		gboxLocation: TGroupBox;
		lblRegion: TLabel;
		lblSite: TLabel;
		tshtSystem: TTabSheet;
		lblSystem: TLabel;
		gboxSystem: TGroupBox;
		lblSys1: TLabel;
		lblSys2: TLabel;
		lblSys3: TLabel;
		tshtType: TTabSheet;
		lblEquipment: TLabel;
		gboxEquip: TGroupBox;
		lblEquip1: TLabel;
		lblEquip2: TLabel;
		tshtBasic: TTabSheet;
		lblCommon: TLabel;
		lblNum: TLabel;
		lblStartDate: TLabel;
		lblUpdateDate: TLabel;
		lblDataGrade: TLabel;
		dbcomboDataGrade: TDBLookupComboBox;
		dbedNum: TDBEdit;
		tshtExtended: TTabSheet;
		lblOther: TLabel;
		dbgOtherData: TDBGrid;
		edAssetID: TEdit;
		lblAssetID: TLabel;
		rxdbcomboSites: TRxDBLookupCombo;
		rxdbcomboRegions: TRxDBLookupCombo;
		rxdbcomboSys3: TRxDBLookupCombo;
		rxdbcomboSys2: TRxDBLookupCombo;
		rxdbcomboSys1: TRxDBLookupCombo;
		rxdbcomboEquip2: TRxDBLookupCombo;
		rxdbcomboEquip1: TRxDBLookupCombo;
		rxdbdateStartDate: TDBDateEdit;
		rxdbdateUpdateDate: TDBDateEdit;
    lblInitialValue: TLabel;
    dbedValue: TDBEdit;
    lblLife: TLabel;
    dbedLife: TDBEdit;
    bitbtnOK: TBitBtn;
    bitbtnAdd: TBitBtn;
		procedure FormCreate(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure bitbtnCancelClick(Sender: TObject);
		procedure pctrlCreateAssetChange(Sender: TObject);
    procedure rxdbcomboRegionsChange(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
		procedure AdditionalTabs(Val: boolean);
	end;

var
	frmCreateAsset: TfrmCreateAsset;

implementation

uses uMain;

var
		Num: LongInt;

{$R *.DFM}
{----------------------------------------------------------}
procedure TfrmCreateAsset.AdditionalTabs(Val: boolean);
begin
	tshtBasic.TabVisible := Val;
	tshtExtended.TabVisible := Val;
end;

{----------------------------------------------------------}
procedure TfrmCreateAsset.FormCreate(Sender: TObject);
begin
	pctrlCreateAsset.ActivePage := tshtLocation;
	ActiveControl := rxdbcomboRegions;
	Additionaltabs(False);
	DMCreateAsset.tblAssetsMain.Active := True;
	DMCreateAsset.tblRegions.Active := True;
	DMCreateAsset.tblSites.Active := True;
	DMCreateAsset.tblSystem1.Active := True;
	DMCreateAsset.tblSystem2.Active := True;
	DMCreateAsset.tblSystem3.Active := True;
	DMCreateAsset.tblEquip1.Active := True;
	DMCreateAsset.tblEquip2.Active := True;
	DMCreateAsset.tblEquip2.Active := True;
	DMCreateAsset.tblDataQuality.Active := True;
	DMCreateAsset.tblAssetFields.Active := True;
	DMCreateAsset.tblAssetsMain.Last;
	DMCreateAsset.tblAssetsMain.Insert;
end;

{----------------------------------------------------------}
procedure TfrmCreateAsset.FormClose(Sender: TObject;
	var Action: TCloseAction);
begin
	DMCreateAsset.tblAssetsMain.Active := False;
	DMCreateAsset.tblRegions.Active := False;
	DMCreateAsset.tblSites.Active := False;
	DMCreateAsset.tblSystem1.Active := False;
	DMCreateAsset.tblSystem2.Active := False;
	DMCreateAsset.tblSystem3.Active := False;
	DMCreateAsset.tblEquip1.Active := False;
	DMCreateAsset.tblEquip2.Active := False;
	DMCreateAsset.tblDataQuality.Active := False;
	DMCreateAsset.tblAssetsOther.Active := False;
	DMCreateAsset.tblAssetFields.Active := False;
	Action := caFree;
end;

{----------------------------------------------------------}
procedure TfrmCreateAsset.bitbtnCancelClick(Sender: TObject);
begin
	DMCreateAsset.tblAssetsMain.Cancel;
	Close;
end;

{----------------------------------------------------------}
procedure TfrmCreateAsset.pctrlCreateAssetChange(Sender: TObject);
var
	Region, Site, Sys1, Sys2, Sys3, Equip1, Equip2: string;
	NumT: LongInt;
begin
	{-- Location --}
	If pctrlCreateAsset.ActivePage = tshtLocation Then
	begin
		rxdbComboRegions.SetFocus;
	end;

	{-- System --}
	If pctrlCreateAsset.ActivePage = tshtSystem Then
	begin
		rxdbcomboSys1.SetFocus;
	end;

	{-- Type --}
	If pctrlCreateAsset.ActivePage = tshtType Then
	begin
		rxdbcomboEquip1.SetFocus;
	end;

	{-- Basic Information --}
	If pctrlCreateAsset.ActivePage = tshtBasic Then
	begin
		with DMCreateAsset do
		begin
			sqlMaxAssetNum.Open;
			sqlMaxAssetNum.Last;
			if sqlMaxAssetNum.BOF then
				Num := 0
			else
				Num := sqlMaxAssetNum.FieldValues['Num']+1;
			sqlMaxAssetNum.Close;
		end;
		dbedNum.Text := Format('%.3d',[Num]);
		dbedNum.SetFocus;
	end;

	{-- Extended --}
	If pctrlCreateAsset.ActivePage = tshtExtended Then
	begin
		{ Find what fields are required for this equipment type, }
		{ and add records to AssetsOther for each field.         }
		with DMCreateAsset do
		begin
			// Save AssetID
			Region :=	tblAssetsMain.FieldByName('RegionCode').AsString;
			Site := tblAssetsMain.FieldByName('SiteCode').AsString;
			Sys1 := tblAssetsMain.FieldByName('Sys1').AsString;
			Sys2 := tblAssetsMain.FieldByName('Sys2').AsString;
			Sys3 := tblAssetsMain.FieldByName('Sys3').AsString;
			Equip1 := tblAssetsMain.FieldByName('Equip1').AsString;
			Equip2 := tblAssetsMain.FieldByName('Equip2').AsString;
			NumT := tblAssetsMain.FieldByName('Num').AsInteger;
			tblAssetsMain.Post;	//Post rec to force GAID creation
			tblAssetsMain.Refresh; // Reread the data
			// Position tblAssetsMain at the newly created Asset to read the GAID
			If tblAssetsMain.FindKey([Region, Site, Sys1, Sys2, Sys3, Equip1, Equip2, NumT]) Then
			begin
//        MessageDlg('Found! GAID = '+Format('%.3d',[tblAssetsMain.FieldByName('GAID').AsInteger]),mtInformation, [mbOK], 0);
				sqlOtherFields.Active := True;
				tblAssetsOther.Active := True;
				sqlOtherFields.First;
				while not DMCreateAsset.sqlOtherFields.EOF do
				begin
					tblAssetsOther.Insert;
					tblAssetsOther.FieldValues['RegionCode']	:= tblAssetsMain.FieldValues['RegionCode'];
					tblAssetsOther.FieldValues['SiteCode']		:= tblAssetsMain.FieldValues['SiteCode'];
					tblAssetsOther.FieldValues['Sys1']				:= tblAssetsMain.FieldValues['Sys1'];
					tblAssetsOther.FieldValues['Sys2']				:= tblAssetsMain.FieldValues['Sys2'];
					tblAssetsOther.FieldValues['Sys3']				:= tblAssetsMain.FieldValues['Sys3'];
					tblAssetsOther.FieldValues['Equip1']			:= tblAssetsMain.FieldValues['Equip1'];
					tblAssetsOther.FieldValues['Equip2']			:= tblAssetsMain.FieldValues['Equip2'];
					tblAssetsOther.FieldValues['Num']					:= tblAssetsMain.FieldValues['Num'];
					tblAssetsOther.FieldValues['GAID']				:= tblAssetsMain.FieldValues['GAID'];
					tblAssetsOther.FieldValues['FieldNum']		:= sqlOtherFields.FieldValues['FieldNum'];
					tblAssetsOther.FieldValues['FieldValue']	:= 0;
					tblAssetsOther.Post;
					sqlOtherFields.Next;
				end;
				sqlOtherFields.Close;
				Application.ProcessMessages;
				{ Display the new fields for the user to complete }
//				tblOtherData.Open;
				sqlOtherData.Open;
			end
			Else
				MessageDlg('PROBLEM! Asset Not Found',mtInformation, [mbOK], 0);
		end;
		dbgOtherData.SetFocus;
	end;
end;

{----------------------------------------------------------}
procedure TfrmCreateAsset.rxdbcomboRegionsChange(Sender: TObject);
begin
	if (rxdbcomboRegions.Text <> '') and
		 (rxdbcomboSites.Text <> '') and
		 (rxdbcomboSys1.Text <> '') and
		 (rxdbcomboSys2.Text <> '') and
		 (rxdbcomboSys3.Text <> '') and
		 (rxdbcomboEquip1.Text <> '') and
		 (rxdbcomboEquip2.Text <> '') then
		AdditionalTabs(True)
	else
		AdditionalTabs(False);
{
	With DMCreateAsset do
	begin
		tblSystem2.Refresh;
		tblSystem3.Refresh;
	end;
}
end;

{----------------------------------------------------------}




end.
{----------------------------------------------------------}
